% Find and demod main

%% Preallocations

% we only want to allocate bits for the data sequence and NOT for the guard
% bits, in this case we have two packages containing guard bits only

rx_bits = [];

% simulate buffers
buffer = zeros(1,nr_samples_per_buffer);
time_index = 1;

%% Initialization

% length of received signal
nr_samples_channel_output = length(rx_passband);

% no remaining samples in first run
remaining_samples = [];

% channel estimation

channel_estimate = [];

%phase estimation 

phase_tx = [];
phase_rx = [];

% package index
package_index = 1;

foundPackage = 0;
counter = 0;

%% Initialization for HEADER

% For the first packages we want to detect the header trai/energyInSamplesInning
% These pararameters will be used to detect the header
rx_final_training_symbols_up_current = rx_final_training_symbols_up_header;
rx_final_training_symbols_current = rx_training_symbols_header;
modulation_decision = 1;

% Only valid for upconverting of 3 right now
QAM_decision = 4;
OFDM_decision = 1;
header_found = 0;
pulse = 1;
k=1;
R = fs/k;

%Important: the number of samples are changed depending on the modulation,
%but it is always the same for the header

if L == 16

    load real_channel_data_L16.mat
    
end


nr_samples_passband_packages = length(header_passband);
nr_symbols_package = length(modulated_header);

%% FIND PACKAGES AND DEMODULATE

% the samples of one package shall be written in one row

for jj=1:ceil(nr_samples_channel_output/nr_samples_per_buffer)
    
    if nr_samples_channel_output-time_index >= nr_samples_per_buffer
        % Fill buffer
        
        buffer = rx_passband(time_index:time_index+nr_samples_per_buffer)';
    else
        % last buffer: buffer that cannot be completely filled by the samples
        
        buffer = rx_passband(time_index:end)';
    end
    
    % find packages in buffer (and remaining samples from last buffer)
    
    rx_samples = [remaining_samples, buffer];

    if header_found==1 
       [ rx_packages_samples, remaining_samples ,foundPackage] = find_packages_fast3( rx_samples', ...
         nr_samples_passband_packages, rx_final_training_symbols_up_current, foundPackage);
    else
         [ rx_packages_samples, remaining_samples, counter ] = find_packages_fast_Sliding_window( rx_samples', counter, ...
         nr_samples_passband_packages, rx_final_training_symbols_up_current);
    end
    
    % downconvert package from passband to baseband
    
    if ~isempty(rx_packages_samples)
        
        rx_samples_bb = zeros(size(rx_packages_samples,1), size(rx_packages_samples,2));
        
        if OFDM_decision==1 
            
            % with OFDM
            
            for ii=1:size(rx_packages_samples,1)
                
                % Removing the carrier
                
                rx_samples_bb(ii,:) = downconvert_package_from_passband_OFDM(...
                    rx_packages_samples(ii,:), fs, f0, R, N, BlockLength);
            end
        else
            
            % if not OFDM
            
            for ii=1:size(rx_packages_samples,1)
                
                % Removing the carrier
                
                rx_samples_bb(ii,:) = downconvert_package_from_passband(...
                    rx_packages_samples(ii,:), fs, f0, R);
            end
        end
        

        % get baseband symbols

        rx_packages_symbols = zeros(size(rx_samples_bb,1), size(rx_samples_bb,2)/k);
        
        for ii=1:size(rx_samples_bb,1)
            rx_packages_symbols(ii,:) = get_symbols_from_package(...
                rx_samples_bb(ii,:), rx_final_training_symbols_current, pulse, fs, f0, R); %% Downconverting
        end

        % OFDM removal
        
        rx_packages_OFDM_demod = zeros(size(rx_packages_symbols,1), ...
            nr_symbols_package);
        
        
        
        if OFDM_decision == 1;
            for ii=1:size(rx_packages_OFDM_demod,1)
                rx_packages_OFDM_demod(ii,:) = OFDM_receiver_new(rx_packages_symbols(ii,:),N, BlockLength, L);
            end

        end
        
        if OFDM_decision == 1
            rx_packages_to_demod = rx_packages_OFDM_demod;
        else
            rx_packages_to_demod = rx_packages_symbols;
        end
        
        
        if check_equalization == 1 || package_index == 1;
        
        if OFDM_decision==1
            
          %  channel estimation & equalization for OFDM
          
            [rx_packages_to_demod] = averaging_channel_estimate(rx_packages_OFDM_demod, ...
                rx_final_training_symbols_current,N, BlockLength);        

            % phase estimation
            % [phase_tx ,phase_rx] = phase_estimate_symbols_more_data(rx_packages_to_demod, packages_symbols,nr_packages,...
            %                          phase_tx,phase_rx);
                                 
        else
            
            %  channel estimation & equalization  without OFDM
            
         [rx_packages_to_demod] = averaging_channel_estimate_without_OFDM(rx_packages_to_demod,rx_final_training_symbols_current);
            
        end
        
        end
        
        if package_index ~= 1;
            
        % demodulation when the header has been found
        
        for ii=1:size(rx_packages_to_demod,1)
            
            % note the -1 in (package_index-1,:), this is due to that the header package should
            % not be included
            
            rx_packages_bits(package_index-1,:) = rx_demodulation(...
                rx_packages_to_demod(ii,:),...
                nr_training_bits_package,modulation_decision, QAM_decision);            

        end
         
        else
            
            % Here the header has been found
                       
           rx_packages_to_demod = rx_packages_to_demod(1:length(modulated_header));
            
            % Demod of header
            
            header_with_zero_padding_and_training = rx_demodulation(...
                rx_packages_to_demod,...
                nr_training_bits_package,modulation_decision, QAM_decision);
            
            % Remove training sequence from header
            
            header_with_zero_padding = header_with_zero_padding_and_training(nr_training_bits_package+1:end);
            
            % Descramble
            
            descrambled_header = xor(header_with_zero_padding, P_header');
            
            % Read header
            
                     
            [modulation_decision,QAM_decision,OFDM_decision,...
            file_format,file_name,nr_bits_input,nr_packages,nr_columns,nr_parity_bits,...
            nr_added_zeros, added_number_zeros_hamming,nr_package_samples,k] = read_header(descrambled_header);
            
            % Parameters necessary if OFDM is disabled
            
            check_received_data = get(handles.checkbox_process_recieved_data,'value');
            
            if check_received_data == 1 && OFDM_decision == 1
                
                k = 1;
                
            elseif check_received_data == 1 && OFDM_decision == 0
                
                k = 5;
                
            end
            
           
            if OFDM_decision == 0
            
            pulse = ones(1,k); 
            R = fs/k;
            
            end
                    
            
            % Create training sequences for data

            data_training;
            
            % Parameters for data packages with and without OFDM
            
            rx_final_training_symbols_up_current = rx_final_training_symbols_up;
            rx_final_training_symbols_current = rx_training_symbols;
            nr_samples_passband_packages = nr_package_samples;
            nr_symbols_package = package_length_bits/log2(QAM_decision);
            foundPackage = 0;
            header_found = 1;    
            
            % Preallocation for packages
    
            % we only want to allocate bits for the data sequence and NOT for the guard
            % bits, in this case we have two packages containing guard bits only
    
            nr_packages = nr_packages-2;

            rx_packages_bits = zeros(nr_packages, package_length_bits);
            rx_packages_without_training = zeros(nr_packages, ...
                           package_length_bits - nr_training_bits_package);
            
                       
            end
            
            
        
        
            package_index = package_index + 1;
    end
    
    % increase time
    
    time_index = time_index + nr_samples_per_buffer + 1;
end

% Remove the header package from package count
package_index = package_index - 1;